///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Precompiled Header
#include "Stdafx.h"

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/**
 *	Helper export method.
 *	This method is called once for each exported helper.
 *	\param		helper		[in] a structure filled with current helper information.
 *	\return		true if success.
 */
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
bool ZCBFormat::ExportHelper(const HelperDescriptor& helper)
{
	// 1) Export common information
	ExportBasicInfo(&helper, &mHelpers);

	// 2) Export helper parameters
	// 2-1) Export helper's type
	mHelpers.Store(udword(helper.mHelperType));
	// 2-2) Export group data
	mHelpers.Store(helper.mIsGroupHead);
	// 2-3) Export gizmo data
	switch(helper.mHelperType)
	{
		case HTYPE_GIZMO_BOX:
		{
			mHelpers
				.Store(helper.mLength)
				.Store(helper.mWidth)
				.Store(helper.mHeight);
		}
		break;

		case HTYPE_GIZMO_SPHERE:
		{
			mHelpers
				.Store(helper.mRadius)
				.Store(helper.mHemi);
		}
		break;

		case HTYPE_GIZMO_CYLINDER:
		{
			mHelpers
				.Store(helper.mRadius)
				.Store(helper.mHeight);
		}
		break;
	}

	return true;
}
